/*
 * Deklarationen zur Programmierschnittstelle fr BoxKite 2.00
 * HB, 9.4.1998
 *
 * Alle AES-Aufrufe sind in der Assembler-Bibliothek FSELLIB.O
 * so realisiert, da die Parameter-bergabe komplett ber den 
 * Stack erfolgt. Dementsprechend sind sie hier durchweg als 'cdecl' 
 * deklariert.
 */
typedef struct					/* Erweiterte DTA-Struktur */
{	char			d_reserved[21];
	unsigned char	d_attrib;
	unsigned int	d_time;
	unsigned int	d_date;
	unsigned long	d_length;
	char			d_fname[256];
}
XDTA;

typedef struct					/* Selectric-Schnittstellenstruktur */
{	unsigned long	id;			/* Selectric ID (SLCT)		*/
	unsigned int	version;	/* version (BCD-Format)		*/
	struct
	{	unsigned           : 7;    /* reserved                     */
		unsigned pthsav    : 1;
		unsigned stdest    : 1;
		unsigned           : 1;
		unsigned numsrt    : 1;   /* numerisches Sortieren     */
		unsigned lower     : 1;
		unsigned dclick    : 1;   /* Ordner mit Doppelklick    */
		unsigned hidden    : 1;   /* versteckte Dateien        */
		unsigned onoff     : 1;   /* Fileselector AN/AUS       */
	} config;
	int	sort;			/* sort-mode (neg. = rev.)	*/
	int	num_ext;		/* number of extensions		*/
	char *(*ext)[];		/* preset extensions		*/
	int	num_paths;		/* number of paths		*/
	char *(*paths)[];		/* preset paths			*/
	int	comm;			/* communication word		*/
	int	in_count;		/* input counter		*/
	void *in_ptr;		/* input pointer		*/
	int	out_count;		/* output counter		*/
	void *out_ptr;		/* output pointer		*/
	int	cdecl	(*get_first)(XDTA *dta, int attrib);
	int	cdecl 	(*get_next)(XDTA *dta);
	int	cdecl	(*release_dir)(void);
}
SLCT_STR;

/* Message-Handler fr den Update von Hintergrundfenstern */
typedef void cdecl (* FSEL_CALLBACK)(int *msg);

/* Fileselector-Aufruf mit Message-Handler */
int cdecl fsel_boxinput(int *global, char *path, char *name, int *button, char *label, FSEL_CALLBACK callback);

/* Sortiermodi fr die FSLX-Aufrufe */
#define SORTBYNAME	0
#define SORTBYDATE	1
#define SORTBYSIZE	2
#define SORTBYTYPE	3
#define SORTBYNONE	4

/* Flags fr FSLX-Dateiauswahl */
#define DOSMODE		1
#define NFOLLOWSLKS	2
#define GETMULTI	8

typedef struct					/* Event-Beschreibung fr 'fslx_evnt()' */
{	int		mwhich;
	int		mx;
	int		my;
	int		mbutton;
	int		kstate;
	int		key;
	int		mclicks;
	int		reserved[9];
	int		msg[16];
}
EVNT;

typedef struct					/* Struktur zum HBFS-Cookie */
{	unsigned int	branch;		/* Sprungbefehl um den struct herum */
	unsigned long	magic;		/* Wert immer 'BxKt' */
	unsigned int	version;	/* Versionsnummer: 0x200 fr 2.00 */
}
BXKT_STR;

/* Dateifilter, derzeit von BoxKite nicht untersttzt */
typedef int cdecl XFSL_FILTER(char *path, char *name, XATTR *xa);

/* Prototypen der FSLX-Aufrufe */
void *cdecl fslx_open(int *global,
				char *title,
				int x, int y,
				int	*handle,
				char *path, int pathlen,
				char *fname, int fnamelen,
				char *patterns,
				XFSL_FILTER *filter,
				char *paths,
				int sort_mode,
				int flags);
int cdecl fslx_evnt(int *global,
				void *fsd,
				EVNT *events,
				char *path,
				char *fname,
				int *button,
				int *nfiles,
				int *sort_mode,
				char **pattern);
int cdecl fslx_close(int *global, void *fsd);
int cdecl fslx_getnxtfile(int *global, void *fsd, char *fname);
void *cdecl fslx_do(int *global,
				char *title,
				char *path, int pathlen,
				char *fname, int fnamelen,
				char *patterns,
				XFSL_FILTER *filter,
				char *paths,
				int *sort_mode,
				int flags,
				int *button,
				int *nfiles,
				char **pattern);
int cdecl fslx_set_flags(int *global, int flags, int *oldval);
