#!/usr/bin/python
# -*- coding: utf-8 -*-

import sys
import os
import os.path
import platform
from PyQt4 import QtGui, QtCore
from pyjoin1 import Ui_MainWindow as Main
from pyjoin_pref import Ui_Dialog as preferences

__version__ = "2.0"

class MeinDialog(QtGui.QMainWindow, Main):
	def __init__(self):
		QtGui.QMainWindow.__init__(self)
		self.setupUi(self)
		
		# Slots einrichten
		self.connect(self.actionExit, QtCore.SIGNAL("triggered()"), self.close)
		self.connect(self.actionOpen, QtCore.SIGNAL("triggered()"), self.onOpen)
		self.connect(self.actionPreferences, QtCore.SIGNAL("triggered()"), self.onPreferences)
		self.connect(self.actionHelp, QtCore.SIGNAL("triggered()"), self.onHelp)
		self.connect(self.pushButtonJoin, QtCore.SIGNAL("clicked()"), self.onJoin)
		
		self.path = os.path.expanduser("~")
		try:
			f=open(os.path.expanduser("~") +"/." +"mpgjoiner_init", "r")
			text=f.readlines()
			for i in text:
				if i[0:4] == "ein=":
					self.path = i.rstrip()[4:]
			f.close()
		except:
			pass

	def onOpen(self):
		# Select files
		self.files = QtGui.QFileDialog.getOpenFileNames(self, self.trUtf8("mpg files"), self.path, self.trUtf8("mpg files (*.mpg *.mpeg);;all files (*.*)"))
		self.label.setText(self.tr("file(s) selected: ") +str(len(self.files)))
		if self.files:
			text=[]
			ein_gesetzt = 0
			self.listWidget.clear()
			self.listWidget.addItems(self.files)
			edit = self.files[0]
			self.lineEdit.clear()
			self.lineEdit.insert(self.files[0])
			self.lineEdit.setFocus()
			self.lineEdit.setCursorPosition(self.files[0].lastIndexOf("."))
			if self.path != os.path.dirname(str(self.files[0])):
				self.path = os.path.dirname(str(self.files[0]))
				try:
					f=open(os.path.expanduser("~") +"/." +"mpgjoiner_init", "r")
					text=f.readlines()
					f.close()
					k=-1
					for i in text:
						k+=1
						if i[0:4] == "ein=":
							text[k] = "ein=" +self.path +"\n"
							ein_gesetzt = 1
					if ein_gesetzt == 0:
						text.append("ein=" +self.path +"\n")
					f=open(os.path.expanduser("~") +"/." +"mpgjoiner_init", "w")
					f.writelines(text)
					f.close()
				except:
					f=open(os.path.expanduser("~") +"/." +"mpgjoiner_init", "w")
					text.append("ein=" +self.path +"\n")
					f.writelines(text)
					f.close()
			
	def onJoin(self):
		# join the files
		newfilename = str(self.lineEdit.text()).strip()
		self.progressBar.reset()
		self.progressBar.minimum
		self.progressBar.maximum
		self.progressBar.setMinimum(0)
		self.progressBar.setMaximum(len(self.files))
		progress = 0
		for i in range (len(self.files)):
			if i == 0:
				zugriff = 'w'
				neue_datei = newfilename
				if os.path.exists(newfilename):
					reply = QtGui.QMessageBox.warning(self, "pyjoin", self.trUtf8("You are about to override the first file, continue?"), QtGui.QMessageBox.Yes|QtGui.QMessageBox.Default, QtGui.QMessageBox.No|QtGui.QMessageBox.Escape)
					if reply == QtGui.QMessageBox.No:
						return
			else:
				zugriff = 'a'
			datei = file(self.files[i], 'r')
			mpg = datei.read()
			datei.close()
			mpg_gesamt = file(newfilename, zugriff)
			mpg_gesamt.write(mpg)
			progress += 1
			self.progressBar.setValue(progress)
			
	def onPreferences(self):
		# set preferences
		self.pref = dict(lang = "en")
		abfrage = SetPreferences(self.pref)
		spr_gesetzt = 0
		text = []
		try:
			f=open(os.path.expanduser("~") +"/." +"mpgjoiner_init", "r")
			text=f.readlines()
			f.close()
		except:
			pass
		if abfrage.exec_():
			k =- 1
			for i in text:
				k += 1
				if i[0:4] == "spr=":
					text[k] = "spr=" +self.pref["lang"] +"\n"
					spr_gesetzt = 1
			if spr_gesetzt == 0:
				text.append("spr=" +self.pref["lang"] +"\n")
			f=open(os.path.expanduser("~") +"/." +"mpgjoiner_init", "w")
			f.writelines(text)
			f.close()
			QtGui.QMessageBox.information(self, "pyjoin", self.trUtf8("Sie müssen das Programm neu starten, damit die Einstellung wirksam wird"))
			
	def onHelp(self):
		QtGui.QMessageBox.about(self, "About pyjoin", """<b>pyjoin</b> v %s <p>Copyright &copy; 2008 Hans Werner May</p> <p>GNU GENERAL PUBLIC LICENSE Version 3</p> <p>This application can be used for joining mpg files.</p> <p>Python %s - Qt %s - PyQt %s on %s""" % (__version__, platform.python_version(), QtCore.QT_VERSION_STR, QtCore.PYQT_VERSION_STR, platform.system()))
		
class SetPreferences(QtGui.QDialog, preferences):
	def __init__(self, pref):
		QtGui.QDialog.__init__(self)
		self.setupUi(self)
		self.pref = pref
		self.comboBox.addItem("en - english")
		self.comboBox.addItem("de - deutsch")
		self.pref["lang"] = str(self.comboBox.currentText()[0:2])
		
		self.connect(self.comboBox, QtCore.SIGNAL("currentIndexChanged(int)"), self.textGet)
		
	def textGet(self):
		self.pref["lang"] = str(self.comboBox.currentText()[0:2])
		
app = QtGui.QApplication(sys.argv)
qtTranslator = QtCore.QTranslator()
lang = "en"
try:
	f=open(os.path.expanduser("~") +"/." +"mpgjoiner_init", "r")
	text=f.readlines()
	for i in text:
		if i[0:4] == "spr=":
			lang=i[4:6]
	f.close()
except:
	pass
if lang != "en":
	if qtTranslator.load("pyjoin", ":/"):
		app.installTranslator(qtTranslator)
dialog = MeinDialog()
dialog.show()
app.exec_()
